/* - IFKitSensorChangeListener - 
 * Set the textbox content based on the input index that is communicating
 * with the interface kit
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.SensorChangeListener;
import com.phidgets.event.SensorChangeEvent;

import javax.swing.JFrame;
import javax.swing.JTextField;
/**
 *
 * @author Owner
 */
public class IFKitSensorChangeListener implements SensorChangeListener{
    
    private JFrame appFrame;
    private JTextField sensorInArray[];
    
    /** Creates a new instance of IFKitSensorChangeListener */
    public IFKitSensorChangeListener(JFrame appFrame, JTextField sensorInArray[])
    {
        this.appFrame = appFrame;
        this.sensorInArray = sensorInArray;
    }

    public void sensorChanged(SensorChangeEvent sensorChangeEvent)
    {
        sensorInArray[sensorChangeEvent.getIndex()].setText(Integer.toString(sensorChangeEvent.getValue()));
    }
    
}
